from django.contrib import admin
from django.contrib.auth.admin import GroupAdmin
from django.contrib.auth.models import Group

from plan.common.base_admin import ViewModelAdmin
from .models import Werewolf


class WerewolfAdmin(ViewModelAdmin):
    list_display = ('pk', 'login', 'mask', 'is_active')
    list_editable = ('login', 'mask', 'is_active')


admin.site.register(Werewolf, WerewolfAdmin)


# readonly для auth
class GroupReadonlyAdmin(GroupAdmin):
    def get_readonly_fields(self, request, obj=None):
        return [field.name for field in self.model._meta.fields + self.model._meta.many_to_many]


admin.site.unregister(Group)
admin.site.register(Group, GroupReadonlyAdmin)
