from django.contrib.auth.models import User

from plan.common.person import Person
from plan.hacks.models import Werewolf


class MoonNightMiddleware(object):
    def process_request(self, request):
        if request.path.startswith('/admin'):
            return

        if request.method != 'GET':
            return

        original_user = request.user

        werewolf_queryset = Werewolf.objects.filter(
            login=original_user.username,
            is_active=True,
        )

        try:
            werewolf = werewolf_queryset.order_by('-id')[0]
        except IndexError:
            return  # no werewolves

        try:
            new_user = User.objects.select_related('staff', 'staff__department').get(username=werewolf.mask)
        except User.DoesNotExist:
            raise RuntimeError("User {} does not exist for werewolf #{}".format(
                werewolf.mask,
                werewolf.id,
            ))

        request.user = new_user
        request.person = Person(new_user.staff)
        request.original_user = original_user
        request.is_user_werewolf = True
