from rest_framework import viewsets

from plan.history.api.filters import HistoryRawEntryFilterSet
from plan.history.api.serializers import HistoryRawEntrySerializer
from plan.history.models import HistoryRawEntry
from plan.api.mixins import TvmAccessMixin, OrderingMixin, DefaultFieldsMixin
from plan.api.permissions import TvmAuthenticated
from plan.api.base import ABCCursorPagination


class HistoryEntryViewSet(DefaultFieldsMixin, TvmAccessMixin, OrderingMixin, viewsets.ReadOnlyModelViewSet):
    pagination_class = ABCCursorPagination
    permission_classes = [TvmAuthenticated]
    serializer_class = HistoryRawEntrySerializer
    filterset_class = HistoryRawEntryFilterSet

    default_fields = (
        'id',
        'date_created',
        'request_data',
        'staff',
        'path',
        'method',
        'endpoint',
        'content_type',
        'object_id',
    )

    queryset = HistoryRawEntry.objects.all()
    ordering = ('-date_created', )
