from django.db import models
from django.contrib.contenttypes.models import ContentType


class HistoryRawEntryManager(models.Manager):

    def _get_request_content_type(self, request):
        return request.META.get('CONTENT_TYPE')

    def _get_endpoint(self, request):
        if request.resolver_match.namespace:
            return '%s:%s' % (request.resolver_match.namespace, request.resolver_match.url_name)
        return request.resolver_match.url_name

    def _get_user(self, request):
        user = getattr(request, 'user')
        if user:
            return getattr(user, 'staff', None)

    def create_entry(self, obj, request):
        content_type = ContentType.objects.get_for_model(type(obj))

        history_entry = self.model(
            staff=self._get_user(request),
            path=request.path,
            endpoint=self._get_endpoint(request),
            method=request.method,
            request_data=request.data,
            request_content_type=self._get_request_content_type(request),
            content_type=content_type,
            object_id=obj.pk,
        )

        return history_entry.save()
