from plan.history.models import HistoryRawEntry


class HistoryMixin:

    def create_history_entry(self, obj):
        HistoryRawEntry.objects.create_entry(obj, self.request)

    def perform_update(self, serializer):
        response = super().perform_update(serializer)
        self.create_history_entry(serializer.instance)
        return response

    def perform_create(self, serializer):
        super().perform_create(serializer)
        self.create_history_entry(serializer.instance)

    def perform_destroy(self, obj):
        self.create_history_entry(obj)
        return super().perform_destroy(obj)
