from django.contrib.contenttypes.fields import GenericForeignKey
from django.db import models
from django.contrib.postgres.fields import JSONField

from plan.history.managers import HistoryRawEntryManager


METHOD_TYPES = (
    ('POST', 'POST'),
    ('PATCH', 'PATCH'),
    ('PUT', 'PUT'),
    ('DELETE', 'DELETE'),
)


class HistoryRawEntry(models.Model):
    date_created = models.DateTimeField(auto_now=True, db_index=True)
    request_data = JSONField(default=dict, blank=True, null=True)
    request_content_type = models.TextField(blank=True, null=True)
    method = models.CharField(choices=METHOD_TYPES, max_length=6)
    path = models.TextField(blank=True, null=True)
    endpoint = models.TextField(blank=True, null=True)
    staff = models.ForeignKey('staff.Staff', null=True, blank=True,)
    content_type = models.ForeignKey('contenttypes.ContentType', on_delete=models.DO_NOTHING)
    object_id = models.CharField(max_length=250, db_index=True)
    content_object = GenericForeignKey()

    objects = HistoryRawEntryManager()
