from django.contrib import admin
from django.core.management import call_command

from plan.holidays.models import Holiday


@admin.register(Holiday)
class HolidayAdmin(admin.ModelAdmin):
    list_filter = ('date',)
    list_display = ('date',)
    date_hierarchy = 'date'

    actions = ('sync',)

    def sync(self, request, queryset):
        call_command('sync_holidays')

    sync.short_description = 'Синхронизировать с календарем'
