from rest_framework import serializers


class HolidaySerializer(serializers.Serializer):
    date_format_args = {'format': '%Y-%m-%d', 'input_formats': ('%Y-%m-%d',)}

    date_from = serializers.DateField(**date_format_args)
    date_to = serializers.DateField(**date_format_args)

    def validate(self, values):
        if values['date_from'] > values['date_to']:
            raise serializers.ValidationError('date_from must precede date_to')
        return values
