import logging
from datetime import datetime

from django.conf import settings
from django.core.management.base import BaseCommand

from plan.holidays.models import Holiday

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):
        log.info('Syncing holidays with calendar')
        today = datetime.now().date()
        radius = settings.HOLIDAY_SYNC_RADIUS
        date_from, date_to = today - radius, today + radius
        Holiday.sync(date_from, date_to)
