import datetime
import logging

from django.conf import settings
from django.utils import timezone

from plan.holidays.models import Holiday

log = logging.getLogger(__name__)

date_is_holiday_type = Holiday.date_is_holiday_type
workday = Holiday.workday
not_workday = Holiday.not_workday
next_workday = Holiday.next_workday
prev_workday = Holiday.prev_workday
holidays_range = Holiday.holidays_range

zero_time = datetime.time(0, 0, 0)


def trim_holidays_and_weekends(dt: datetime.datetime, duty_on_holidays: bool, duty_on_weekends: bool) -> datetime.datetime:
    dt = dt.astimezone(settings.DEFAULT_TIMEZONE)
    if (
        dt.time() == zero_time and
        not workday((dt - timezone.timedelta(minutes=1)), duty_on_holidays, duty_on_weekends)
    ):
        return prev_workday(dt, duty_on_holidays, duty_on_weekends)[0] + timezone.timedelta(days=1)

    return next_workday(dt, duty_on_holidays, duty_on_weekends)[0]


def end_datetime_to_end_date(end_datetime: datetime.datetime) -> datetime.date:
    dt = end_datetime.astimezone(settings.DEFAULT_TIMEZONE)
    if dt.time() == zero_time:
        return dt.date() - timezone.timedelta(days=1)
    else:
        return dt.date()
