from django.core.management.base import BaseCommand

from plan.services.models import Service, ServiceMember
from plan.roles.models import Role
from plan.common.utils.oauth import get_abc_zombik


class Command(BaseCommand):
    def handle_noargs(self, *args, **options):
        germes = get_abc_zombik()

        base_query = (
            ServiceMember.objects
            .exclude(service__state=Service.states.DELETED)
        )

        owners = base_query.filter(role=Role.get_exclusive_owner())
        from_dpt = base_query.exclude(from_department=None)

        counter = 0

        for sm in set(owners) | set(from_dpt):
            history = list(sm.partratehistory_set.all())

            if not (len(history) and history[0].old_part_rate is None and
                    history[0].new_part_rate is None):

                sm.partratehistory_set.create(
                    staff=germes,
                    old_part_rate=None,
                    new_part_rate=None,
                    modified_at=sm.created_at,
                )
                counter += 1

        print("Created %d empty history entries" % counter)
