# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-08-06 15:19
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
from django.db.models import Subquery, OuterRef


def populate_member_staff(apps, schema_editor):
    PartRateHistory = apps.get_model('hr', 'partratehistory')
    PartRateHistory.objects.update(
        member_staff=Subquery(
            PartRateHistory.objects.filter(pk=OuterRef('pk')).values('service_member__staff')[:1]
        )
    )


def undo(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0007_auto_20200520_0330'),
        ('hr', '0002_auto_20170606_1551'),
    ]

    operations = [
        migrations.AddField(
            model_name='partratehistory',
            name='member_staff',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='part_rates',
                                    to='staff.Staff'),
        ),
        migrations.AlterField(
            model_name='partratehistory',
            name='new_part_rate',
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=5, null=True),
        ),
        migrations.AlterField(
            model_name='partratehistory',
            name='old_part_rate',
            field=models.DecimalField(blank=True, decimal_places=4, max_digits=5, null=True),
        ),
        migrations.AlterField(
            model_name='partratehistory',
            name='service_member',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                    to='services.ServiceMember'),
        ),
        migrations.RunPython(populate_member_staff, undo),
        migrations.AlterField(
            model_name='partratehistory',
            name='member_staff',
            field=models.ForeignKey(null=False, on_delete=django.db.models.deletion.CASCADE, related_name='part_rates',
                                    to='staff.Staff'),
        ),
    ]
