from django.db import models

from plan.services import models as services_models
from plan.staff.models import Staff
from plan.common.fields import StrictForeignKey


class PartRateHistory(models.Model):
    """History of changing part_rate for service_member.

     * service_member - object where part_rate changed
     * member_staff - Staff of changed object (in case we destroy service_member)
     * staff - person, who changed part_rate
     * old_part_rate - old participation coefficent
     * new_part_rate - new participation coefficent
     * modified_at - timestamp of modification
     """
    service_member = StrictForeignKey(
        services_models.ServiceMember,
        db_index=True,
        null=True,
        blank=True,
        on_delete=models.SET_NULL,
    )
    member_staff = models.ForeignKey(
        Staff,
        db_index=True,
        null=True,
        related_name='part_rates'
    )
    staff = StrictForeignKey(
        Staff,
        null=True,
        blank=True,
        on_delete=models.SET_NULL
    )
    old_part_rate = models.DecimalField(
        max_digits=5,
        decimal_places=4,
        null=True,
        blank=True
    )
    new_part_rate = models.DecimalField(
        max_digits=5,
        decimal_places=4,
        null=True,
        blank=True
    )

    modified_at = models.DateTimeField(
        auto_now_add=True,
        db_index=True,
    )
