import datetime
import mimetypes

from django.utils import timezone

from plan.celery_app import app
from plan.common.utils import tasks
from plan.common.models import date_from_str
from plan.hr import helpers
from plan.hr import models
from plan.notify.core.email import send_mail
from plan.staff.models import Staff

KEEP_HISTORY_DAYS = 365


@tasks.lock_task
def clean_history_older_than_year():
    year_ago = timezone.now() - datetime.timedelta(days=KEEP_HISTORY_DAYS)
    models.PartRateHistory.objects.filter(
        modified_at__gte=year_ago
    ).remove()


@app.task
def make_team_xls(requester_login, month_start, month_end):
    month_start = date_from_str(month_start)
    month_end = date_from_str(month_end)

    report = helpers.get_team_xls(month_start, month_end)

    requester = Staff.objects.get(login=requester_login)

    filename = 'important_service_members.xls'
    mime_type, encoding_ = mimetypes.guess_type(filename)

    send_mail(
        subject='Отчет occupancy.yandex-team.ru',
        body='',
        to=[requester.email],
        attach=(filename, report, mime_type),
    )
