from django.conf.urls import url

from plan.hr import views


urlpatterns = [
    url(
        r'^important_teams.xls$',
        views.ImportantServiceTeamsView.as_view(),
        name='important_teams_with_period',
    ),
    url(
        r'^actions/mark_important/$',
        views.MarkImportantView.as_view(),
        name='mark_important',
    ),
    url(
        r'^actions/edit_participation/$',
        views.EditParticipationView.as_view(),
        name='edit_participation',
    ),
    url(
        r'^services/(?P<pk_or_slug>[-a-zA-Z0-9_]+)/$',
        views.ServiceParticipationView.as_view(),
        name='service_participation_backend',
    ),
    url(
        r'^services/(?P<pk_or_slug>[-a-zA-Z0-9_]+)/history/$',
        views.ServiceParticipationHistoryView.as_view(),
        name='service_participation_history',
    ),
    url(
        r'^persons/(?P<login>[-a-zA-Z0-9_]+)/$',
        views.PersonParticipationView.as_view(),
        name='person_participation_backend',
    ),
    url(
        r'^persons/(?P<login>[-a-zA-Z0-9_]+)/request-(?P<mode>review|raise)/$',
        views.PersonParticipationDisputeView.as_view(),
        name='person_participation_dispute',
    ),
    url(
        r'^persons/(?P<login>[-a-zA-Z0-9_]+)/subordinates/$',
        views.PersonParticipationSubordinatesView.as_view(),
        name='person_participation_subordinates',
    ),
    url(
        r'^persons/(?P<login>[-a-zA-Z0-9_]+)/subordinates/history/$',
        views.PersonSubordinatesHistoryView.as_view(),
        name='person_participation_subordinates_history',
    ),
    url(
        r'^persons/(?P<login>[-a-zA-Z0-9_]+)/history/$',
        views.PersonParticipationHistoryView.as_view(),
        name='person_participation_history',
    ),
]
