import logging

from plan.idm.adapters.base import BaseAPI

log = logging.getLogger(__name__)


class ApproveRequestManager(BaseAPI):

    @classmethod
    def approve(cls, manager, pk, login):
        log.info('Approve request %s by %s', pk, login)

        return cls._update(manager, pk, login, True)

    @classmethod
    def decline(cls, manager, pk, login):
        log.info('Decline request %s by %s', pk, login)

        return cls._update(manager, pk, login, False)

    @classmethod
    def _update(cls, manager, pk, login, approve):
        verb = 'подтверждена' if approve else 'отклонена'
        params = {
            'approve': approve,
            'comment': 'Роль %s через ABC' % verb,
            '_requester': login,
        }
        return manager.post('approverequests/%s/' % pk, data=params)

    @classmethod
    def get_list(cls, manager, approver, state='pending', limit=10000):
        filters = {
            'system': 'abc',
            'status': state,
            'limit': limit,
            'approver': approver
        }
        data = manager.get('approverequests/', params=filters)

        role_requests = [
            {
                'idm_request_id': request['role']['id'],
                'requester': request['requester']['username'],
                'user': request['role']['user']['username'] if request['role'].get('user') else None,
                'group': request['role']['group']['id'] if request['role'].get('group') else None,
                'services': request['role']['data'],
                'role': request['role']['node']['data']['role']
            }
            for request in data['objects']
            if request['role']['node']['data']['type'] == 'services'  # игнорируем внутренние роли ABC
        ]

        # здесь мы строим иерархию сервиса, от старшего родителя к самому сервису
        # IDM отдает её в довольно странном виде, например:
        # Другие Сервисы > Мой Сервис
        # {'services_key': 'meta_other', 'meta_other_key': 'myservice', 'myservice_key': '*'}
        for request in role_requests:
            services = request.pop('services', {})
            service = services.get('services_key')
            while service:
                child = services.get(service + '_key')
                if child == '*':
                    break
                else:
                    service = child

            request['service'] = service

        return role_requests
