import logging

from plan.idm.adapters.base import BaseAPI

log = logging.getLogger(__name__)


class RoleNodeManager(BaseAPI):

    @classmethod
    def get(cls, manager, system, node_path):
        # GET https://idm-api.yandex-team.ru/api/v1/rolenodes/<path>
        log.info('Get rolenode %s%s', system, node_path)

        node_data = manager.get('rolenodes/%s%s' % (system, node_path))
        return node_data

    @classmethod
    def create(cls, manager, **kwargs):
        # POST https://idm-api.yandex-team.ru/api/v1/rolenodes/
        log.info('Create rolenode %s from %s', kwargs['slug'], kwargs['parent'])

        node_data = manager.post('rolenodes/', data=kwargs)
        return node_data

    @classmethod
    def update(cls, manager, system, node_path, **params):
        # PUT https://idm-api.yandex-team.ru/api/v1/rolenodes/<system>/<node_path>/
        log.info('Update rolenode %s%s with %s', system, node_path, params)

        manager.put('rolenodes/%s%s' % (system, node_path), data=params)

    @classmethod
    def move(cls, manager, system, node_path, new_parent_path, **params):
        # PUT https://idm-api.yandex-team.ru/api/v1/rolenodes/<system>/<node_path>/
        log.info('Move rolenode %s%s to %s', system, node_path, new_parent_path)

        params['parent'] = new_parent_path
        manager.put('rolenodes/%s%s' % (system, node_path), data=params)

    @classmethod
    def delete(cls, manager, system, node_path, **params):
        # DELETE https://idm-api.yandex-team.ru/api/v1/rolenodes/<path>
        log.info('Delete rolenode %s%s', system, node_path)

        return manager.delete('rolenodes/%s%s' % (system, node_path), data=params)
