import logging

from plan.idm.adapters.base import BaseAPI

log = logging.getLogger(__name__)


class RoleRequestManager(BaseAPI):

    @classmethod
    def get_rolerequest(cls, manager, pk):
        log.info('Get rolerequest %d', pk)

        rolerequest_data = manager.get('rolerequests/%s/' % pk)
        return rolerequest_data

    @classmethod
    def request(cls, manager, **kwargs):
        log.info('Request role with %r', kwargs)
        kwargs['no_meta'] = True
        return manager.post('rolerequests/', data=kwargs)
