# encoding: utf-8


from django.utils.translation import ugettext_lazy as _

STATES = {
    'approved': _('Подтверждена'),
    'created': _('Создана'),
    'declined': _('Отклонена'),
    'deprived': _('Отозвана'),
    'depriving': _('Отзывается'),
    'expired': _('Просрочена'),
    'failed': _('Ошибка'),
    'granted': _('Выдана'),
    'imported': _('Импортирована'),
    'need_request': _('Нужно перезапросить'),
    'onhold': _('Ожидание'),
    'requested': _('Запрошена'),
    'rerequested': _('Перезапрошена'),
    'review_request': _('Перезапрошена в связи с регулярным пересмотром'),
    'sent': _('Передана в систему'),

    'awaiting': _('Ожидание'),
    'failed_in_idm': _('Ошибка в IDM'),
    'expiring': _('Истекает'),
    'depriving_validation': _('Валидация отзыва'),
}

INACTIVE_STATES = ['created', 'imported', 'requested', 'approved', 'sent', 'awaiting']
ACTIVE_STATES = [
    'granted', 'onhold',
    'need_request', 'rerequested', 'review_request',
    'depriving', 'depriving_validation',
]
DEPRIVED_STATES = ['deprived', 'depriving', 'depriving_validation', 'failed']

INACTIVE_TEAM_STATES = INACTIVE_STATES + ['rerequested']

IDM_RETURNABLE_ROLE_STATES = {
    'requested', 'approved', 'awaiting', 'granted', 'review_request', 'need_request',
    'rerequested', 'sent', 'imported', 'onhold', 'created'
}
IDM_NOT_RETRIABLE_ROLE_STATES = {'failed'}
