# encoding: utf-8


from plan.api import exceptions


class IDMError(exceptions.IntegrationError):
    default_detail = 'IDM did not fulfil the request.'


class BadRequest(IDMError):
    status_code = 400
    default_code = 'idm_bad_request'


class AuthError(IDMError):
    status_code = 401
    default_code = 'idm_auth_error'
    default_detail = 'Error authenticating with IDM.'


class Forbidden(IDMError):
    status_code = 403
    default_code = 'idm_forbidden'
    default_detail = 'IDM returned forbidden.'


class NotFound(IDMError):
    status_code = 404
    default_code = 'idm_not_found'
    default_detail = 'IDM returned not found.'


class SystemBroken(IDMError):
    status_code = 409
    default_code = 'idm_conflict'
    default_detail = 'System ABC is broken in IDM.'


class Conflict(IDMError):
    status_code = 409
    default_code = 'idm_conflict'
    default_detail = 'IDM returned conflict.'


class TimeoutError(IDMError):
    status_code = 500
    default_code = 'idm_timeout_error'
    default_detail = 'Request to IDM timed out.'


class ReadonlyError(IDMError):
    status_code = 500
    default_code = 'idm_readonly'
    default_detail = 'IDM is in readonly state, all operations are impossible.'


class UnavailableError(IDMError):
    status_code = 500
    default_code = 'idm_unavailable'
    default_detail = 'IDM is unavailable.'
