# Это копипаста views из django_idm_api.
# Разница в том, что тут get_hooks заменен на явное использование дополнительных хуков
# Это нужно для того что бы поддержать в IDM вторую систему для ролей доступов
# В первой системе plan.api.idm.hooks мы сами следим за членствами в группах
# Во второй системе plan.api.idm.external_subsystem_hooks IDM разворачивает нам группы в людей
import logging

from django.views.decorators.http import require_GET

from django_idm_api.exceptions import UnsupportedApi
from django_idm_api.utils import as_json, token_auth

from plan.api.idm.external_subsystem_hooks import Hooks


JSONDecodeError = ValueError


log = logging.getLogger(__name__)


@as_json
@require_GET
@token_auth
def info(request, **kwargs):
    """Формируем дерево ролей, но отправляем только первые N ролей на каждом уровне, для остальных проставляем
    'next-url'. Если запрос уже включает 'next-url', отправляем следующие N ролей в соответствии в запросом.
    Сортируем каждый уровень 'values' по ключам и включаем в итоговое дерево только первые N."""

    try:
        hooks = Hooks(**kwargs)
        tree = hooks.info()
    except Exception:
        log.exception('during "/info" with request: %s', request)
        raise

    if tree['code'] != 0:
        return tree

    if 'code' not in tree:
        tree['code'] = 0

    return tree


@as_json
@require_GET
@token_auth
def get_roles(request, **kwargs):
    hooks = Hooks(**kwargs)
    try:
        roles = hooks.get_roles(request)
    except NotImplementedError:
        raise UnsupportedApi('Unsupported API method')
    return roles
