import requests
import logging

from django.conf import settings

log = logging.getLogger(__name__)


def make_request(iteration, limit):
    headers = {
        'Content-type': 'application/json',
        'Authorization': 'OAuth ' + settings.NANNY_TOKEN
    }

    request_query = {
        'limit': limit,
        'skip': iteration
    }

    response = requests.get(
        settings.NANNY_URL,
        params=request_query,
        verify=settings.ABC_CA_ROOT_PATH,
        headers=headers
    )

    if not response.ok:
        log.warning('Nanny responded with {}'.format(response.status_code))
        return None

    return response.json()


def count_instances_nanny(limit=200):
    count_instances_abc = 0
    count_instances_not_abc = 0

    iteration = 0

    while True:
        response = make_request(iteration, limit)

        if response is None:
            count_instances_abc = count_instances_not_abc = None
            break

        if len(response['result']) == 0:
            break

        for service in response['result']:
            count_service_instances = len(service['runtime_attrs']['content']['instances']['instance_list'])

            if service['info_attrs']['content']['abc_group'] == 0:
                count_instances_not_abc += count_service_instances

            else:
                count_instances_abc += count_service_instances

            iteration += 1

    return {
        'count_instances_abc': count_instances_abc,
        'count_instances_not_abc': count_instances_not_abc
    }
