# flake8: noqa
from django.db import migrations


def remove_old_permissions(apps, schema_editor):
    InternalRole = apps.get_model('internal_roles', 'InternalRole')
    Permission = apps.get_model('auth', 'Permission')

    codenames = [codename for codename, desc in InternalRole._meta.permissions]

    existing_perms = (
        Permission.objects
        .filter(codename__in=codenames)
        .exclude(content_type__app_label='internal_roles')
    )

    for perm in existing_perms:
        for user in perm.user_set.all():
            try:
                substitute = Permission.objects.get(
                    codename=perm.codename, content_type__app_label='internal_roles')
                user.user_permissions.add(substitute)
            except Permission.DoesNotExist:
                pass
            user.user_permissions.remove(perm)

    existing_perms.delete()


class Migration(migrations.Migration):

    dependencies = [
        ('internal_roles', '0002_roles_as_perms'),
    ]

    operations = [
        migrations.RunPython(remove_old_permissions, reverse_code=migrations.RunPython.noop),
    ]
