from django.db import models
from django.conf import settings
from django.utils.translation import ugettext_lazy as _


class InternalRole(models.Model):
    role = models.CharField(max_length=255, db_index=True)
    staff = models.ForeignKey('staff.Staff', verbose_name=_('Сотрудник'))

    class Meta:
        verbose_name = _('Internal roles')
        verbose_name_plural = _('Internal role')
        unique_together = [('role', 'staff')]
        permissions = settings.ABC_PERMISSIONS
