from django.contrib import admin

from django_celery_beat.models import PeriodicTask
from django_celery_beat.admin import PeriodicTaskAdmin as BasePeriodicTaskAdmin


class PeriodicTaskAdmin(BasePeriodicTaskAdmin):
    """
    Расширяем базовый PeriodicTaskAdmin, добавляя экшн start_now
    для запуска периодической таски прямо сейчас
    """
    actions = ['start_now']
    search_fields = ('name', 'task')

    def start_now(self, request, queryset):
        import json
        from celery import registry
        for periodic_task in queryset.all():
            task = registry.tasks.get(periodic_task.task)
            if task is None:
                self.message_user(
                    request,
                    'Задача {} не существует'.format(periodic_task.task),
                )
                return

            try:
                task_args = json.loads(periodic_task.args)
                task_kwargs = json.loads(periodic_task.kwargs)
            except ValueError:
                self.message_user(request, 'Невалидный JSON в параметрах')
            else:
                task.delay(*task_args, **task_kwargs)

    start_now.short_description = 'Запустить сейчас'


admin.site.unregister(PeriodicTask)
admin.site.register(PeriodicTask, PeriodicTaskAdmin)
