from django.core.management.base import BaseCommand
from django.apps import apps

from closuretree.models import ClosureModelBase

from plan.common.utils import closuretree


class Command(BaseCommand):

    args = '<app_name app_name ...>'
    help = 'Creates graphs for class-based views.'

    def add_arguments(self, parser):
        parser.add_argument('--app', type=str)
        parser.add_argument('--name', type=str)
        parser.add_argument('--batch_size', type=int, default=5000)

    def handle(self, *args, **options):
        app = options['app']
        name = options['name']
        print(f'Attempting to regenerate closure tree for model {app}.{name}')
        model = apps.get_model(app, name)

        if not isinstance(model, ClosureModelBase):
            print('The model requested if not a django-closuretree model!\nAborting...')
            return

        closuretree.regenerate_closure_tree(model, batch_size=options['batch_size'])

        print('Done!')
