import waffle

from django.shortcuts import render_to_response


class MaintenanceMiddleware(object):
    def process_request(self, request):
        if request.path.startswith('/admin'):
            return

        if waffle.flag_is_active(request, 'maintenance__off'):
            return
        else:
            return render_to_response('maintenance.html')
