from django.core.management.base import BaseCommand

from plan.mdh.utils import pick_services, write_to_logbroker, ExportParams


class Command(BaseCommand):
    """Запускает полный экспорт данных для MDH.

    Если передан --slugs то экспорт ограничится
    только указанными сервисами (через запятую).

    Примеры:
        $ abc mdh_reexport
        $ abc mdh_reexport --slugs "a,b,x"

    """
    help = 'Perform data export for MDH'

    def add_arguments(self, parser):
        parser.add_argument('--slugs', type=str, default='')

    def handle(self, *args, **options):
        self.stdout.write('Exporting all relevant records for MDH ...')

        slugs = []

        for item in options.get('slugs', '').split(','):
            item = item.strip()
            if item:
                slugs.append(item)

        latest_dt = write_to_logbroker(pick_services(ExportParams(
            slugs=slugs,
        )))

        self.stdout.write('Export finished. Latest record datetime: %s' % latest_dt)
