from plan.mdh.utils import write_to_logbroker, pick_services, ExportParams
from plan.periodic.utils import periodic_task


@periodic_task(name='export_to_mdh')
def export_to_mdh(params: dict) -> dict:
    """Производит экспорт данных для MDH."""

    export_params = ExportParams.fromdict(params)
    services = pick_services(export_params)

    since = export_params.since

    if services:
        since = write_to_logbroker(services)

    return export_params.todict(since=since)
