from django.db.models import Q

from metrics_framework.decorators import metric

from plan.duty.models import Schedule, Service, Problem, Shift, Staff


@metric('duty_counters')
def duty_counters():
    shift_problems = Problem.objects.active().future()
    schedule_problems = Problem.objects.active().of_schedules()
    problematic_services = Service.objects.filter(
        Q(pk__in=shift_problems.values('shift__schedule__service')) |
        Q(pk__in=schedule_problems.values('schedule__service'))
    )
    return [
        {
            'slug': 'services_count',
            'value': Schedule.objects.values('service').distinct().count(),
        },
        {
            'slug': 'schedules_count',
            'value': Schedule.objects.count(),
        },
        {
            'slug': 'schedules_noorder',
            'value': Schedule.objects.no_order().count(),
        },
        {
            'slug': 'schedules_manual',
            'value': Schedule.objects.manual_order().count(),
        },
        {
            'slug': 'shift_problems_count',
            'value': shift_problems.count(),
        },
        {
            'slug': 'schedule_problems_count',
            'value': schedule_problems.count(),
        },
        {
            'slug': 'problematic_services',
            'value': problematic_services.count(),
        },
        {
            'slug': 'staff_in_schedules_count',
            'value': Staff.objects.filter(id__in=Shift.objects.future().values('staff_id')).count(),
        },
        {
            'slug': 'active_staff_in_schedules_count',
            'value': Staff.objects.filter(id__in=Shift.objects.current_shifts().values('staff_id')).count(),
        },
    ]
