from metrics_framework.decorators import metric

from plan.idm.manager import idm_manager


def inconsistencies_count(incon_type):
    manager = idm_manager()
    params = {
        'system': 'abc',
        'state': 'active',
        'type': incon_type,
    }
    idm_data = manager.get('inconsistencies/', params=params)
    return idm_data['meta']['total_count']


@metric('idm_inconsistencies')
def get_idm_inconsistencies_count():
    return [
        {'slug': 'abc_has', 'value': inconsistencies_count('system_has_we_dont')},
        {'slug': 'idm_has', 'value': inconsistencies_count('we_have_system_dont')},
        {'slug': 'unknown_role', 'value': inconsistencies_count('system_has_unknown_role')},
    ]
