from metrics_framework.decorators import metric

from plan.unistat.models import MetricsRecord


@metric('nanny')
def get_nanny_services_count():
    metrics_record = MetricsRecord.objects.get()
    return [
        {'slug': 'with_abc', 'value': metrics_record.metrics['nanny_services_with_abc']},
        {'slug': 'without_abc', 'value': metrics_record.metrics['nanny_services_without_abc']}
    ]


@metric('qloud_projects')
def get_qloud_projects_count():
    metrics_record = MetricsRecord.objects.get()
    return [
        {'slug': 'with_abc', 'value': metrics_record.metrics['qloud_projects_with_abc']},
        {'slug': 'without_abc', 'value': metrics_record.metrics['qloud_projects_without_abc']}
    ]


@metric('qloud_applications')
def get_qloud_applications_count():
    metrics_record = MetricsRecord.objects.get()
    return [
        {'slug': 'with_abc', 'value': metrics_record.metrics['qloud_apps_with_abc']},
        {'slug': 'without_abc', 'value': metrics_record.metrics['qloud_apps_without_abc']}
    ]
