import logging

from django.conf import settings

from plan.common.utils.tasks import lock_task
from plan.notify.shortcuts import deliver_email
from plan.notify.apps.services import aggregators

logger = logging.getLogger(__name__)


@lock_task
def send_approve_service_team_reminder():
    """
    Еженедельная рассылка о необходимости утверждения изменений
    в командах сервисов
    """

    for recipient, context in aggregators.weekly_reminder():
        deliver_email(
            notification_id='notifications.services.approve_team_reminder',
            context=context,
            recipients=[recipient],
            from_email=settings.ABC_FROM_EMAIL,
        )
