import logging


logger = logging.getLogger(__name__)


class NotificationGeneratorBackend(object):
    """
    Бэкенд -- независимая штука, нужна, чтобы из определенного набора данных
    сформировать что-то что можно отдать совместимым генераторам
    Бэкенд можно вызывать в агрегаторе в build_entries, если в нем много логики.
    В простых случаях он не нужен.
    """

    def __init__(self, data):
        super(NotificationGeneratorBackend, self).__init__()
        self.data = data

    def __iter__(self):
        for item in self.data:
            yield self.build_entry(item)

    def build_entry(self, item):
        raise NotImplementedError
