from django.conf import settings

from plan.staff.constants import GENDER, LANG


class Recipient(object):
    """
    Класс получателя, обладающий нужными полями как у сотрудника, чтобы можно
    было отправлять ему письма.

    Рассылки, используемые в одном месте можно создать, указав email
    tb = Recipient(email='turkey_bonuses@', lang_ui=LANG.EN)
    Рассылки, используемые в нескольких местах можно наследовать
    как ToolsRecipient, определив `_email`.

    FIXME: Возможно, стоит подумать и реализовать это получше, потому пол и
    флаг уволенности у рассылки выглядят нелогично.
    """
    _email = None
    is_dismissed = False
    gender = GENDER.MALE

    lang_ui = LANG.RU

    def __init__(self, email=None, lang_ui=None, gender=None):
        """
        :param email: В виде 'login@ya.ru' или 'login@' (дополнится
            yandex-team.ru)
        :param lang_ui: язык plan.staff.constants.LANG
        :param gender: пол plan.staff.constants.GENDER
        """
        self._email = email or self._email
        self.lang_ui = lang_ui or self.lang_ui
        self.gender = gender or self.gender

        # проверим, что есть поле email либо у класса, либо у экземпляра
        assert hasattr(self, '_email'), 'Email field is required for this class'

    def get_email(self):
        email = self._email
        if email.endswith('@'):
            email += 'yandex-team.ru'
        return email

    @property
    def email(self):
        return self.get_email()

    def __repr__(self):
        return self.get_email()

    def __hash__(self):
        return hash(self.email)

    def __eq__(self, other):
        return isinstance(other, Recipient) and self.email == other.email


class ToolsRecipient(Recipient):
    _email = settings.TOOLS_EMAIL
