from django.template import Library
from django.conf import settings
from django.utils.html import format_html, mark_safe

register = Library()


@register.simple_tag
def person_link(person):
    return format_html(
        mark_safe('<a href="{}/{}/">{}</a>'),
        settings.STAFF_URL,
        person.login,
        person.get_full_name(),
    )
