import logging

import json

from django import template
from django.conf import settings
from django.utils.safestring import mark_safe

from ids.services.formatter.api import convert_to_html

from plan.common.utils.hiderefer import get_hidereferred

log = logging.getLogger(__name__)
register = template.Library()
register = template.Library()

STAFF_LINK_TEMPLATE = '<lego:b-user url="http://staff.yandex-team.ru/%(login)s" ' \
                      'card="%(login)s" %(attrs)s>%(name)s</lego:b-user>'

STAFF_LINK_TEMPLATE_PLAN = (
    '<lego:b-user url="http://staff.yandex-team.ru/%(login)s" '
    'card="%(login)s">%(first_name)s %(last_name)s</lego:b-user>')


@register.simple_tag
def genderize(staff, male_variant, female_variant):
    if getattr(staff, 'gender', 'M') == 'F':
        return female_variant
    else:
        return male_variant


@register.filter
def staff_link(staff, inflection=None):
    if inflection:
        name = staff.inflections.inflect(inflection)
    else:
        name = staff.get_full_name()

    login = staff.login

    if staff.is_dismissed:
        attrs = 'lego:type="fired"'
    else:
        attrs = ''

    return mark_safe(STAFF_LINK_TEMPLATE % {
        'login': login,
        'name': name,
        'attrs': attrs,
    })


@register.filter
def wiki_text_to_html(text):
    try:
        return convert_to_html(
            text,
            user_agent=settings.ABC_IDS_USER_AGENT,
            config=settings.ABC_IDS_WIKIFORMATTER_EMAIL_CONFIG,
            version=settings.ABC_IDS_WIKIFORMATTER_VERSION
        )
    except Exception:
        log.exception('Exception during formatting wiki_text %s', text)
        return text


@register.filter
def multiply(value, arg):
    return value * arg


@register.filter
def qs_filter(queryset, field_with_value):
    return queryset.filter(**json.loads(field_with_value))


@register.filter
def date_point(date):
    return date.strftime('%d.%m.%Y')


register.filter(name='hiderefer')(get_hidereferred)
