from django.conf import settings
from rest_framework.permissions import BasePermission


class OEBSAuthenticated(BasePermission):
    def has_permission(self, request, view):
        ticket = getattr(request, 'tvm_service_ticket', None)
        if ticket is not None and ticket.src in settings.OEBS_TVM_CLIENT_ID_LIST:
            return True
        return False
