from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from plan.common.utils.enum import EnumMeta, EnumChoice

OEBS_HARDWARE_FLAG = 'use_for_hardware'
OEBS_HR_FLAG = 'use_for_hr'
OEBS_PROCUREMENT_FLAG = 'use_for_procurement'
OEBS_REVENUE_FLAG = 'use_for_revenue'
OEBS_GROUP_ONLY_FLAG = 'use_for_group_only'

OEBS_FLAGS = {
    OEBS_HARDWARE_FLAG: 'oebs_use_for_hardware',
    OEBS_HR_FLAG: 'oebs_use_for_hr',
    OEBS_PROCUREMENT_FLAG: 'oebs_use_for_procurement',
    OEBS_REVENUE_FLAG: 'oebs_use_for_revenue',
    OEBS_GROUP_ONLY_FLAG: 'oebs_use_for_group_only',
}


class OEBS_DEVIATIONS_REASONS:
    FLAG = 'flag'
    NAME = 'name'
    RESOURCE = 'resource'
    PARENT = 'parent'


OEBS_MATCHING_FLAGS_AND_ROLES = {
    OEBS_HARDWARE_FLAG: settings.OEBS_HARDWARE_ROLE_CODE,
    OEBS_HR_FLAG: settings.OEBS_HR_ROLE_CODE,
    OEBS_PROCUREMENT_FLAG: settings.OEBS_PROCUREMENT_ROLE_CODE,
    OEBS_REVENUE_FLAG: settings.OEBS_REVENUE_ROLE_CODE,
}


class ACTIONS(metaclass=EnumMeta):
    CHANGE_FLAGS = EnumChoice('change_flags', name=_('Синхронизация с OEBS'))
    RENAME = EnumChoice('rename', name=_('Переименование'))
    MOVE = EnumChoice('move', name=_('Перемещение'))
    CLOSE = EnumChoice('close', name=_('Закрытие'))
    DELETE = EnumChoice('delete', name=_('Удаление'))


class STATES(metaclass=EnumMeta):
    OPEN = EnumChoice('open', name=_('Открыто'))
    APPROVING = EnumChoice('approving', name=_('Согласовывается'))
    VALIDATING_IN_OEBS = EnumChoice('validating_in_oebs', name=_('Валидируется в OEBS'))
    VALIDATED_IN_OEBS = EnumChoice('validated_in_oebs', name=_('Провалидировано в OEBS'))
    APPROVED = EnumChoice('approved', name=_('Согласовано'))
    DECLINED = EnumChoice('declined', name=_('Отклонено'))
    APPLYING_IN_OEBS = EnumChoice('applying_in_oebs', name=_('Применяется в OEBS'))
    APPLIED_IN_OEBS = EnumChoice('applied_in_oebs', name=_('Применено в OEBS'))
    APPLIED = EnumChoice('applied', name=_('Применено'))
    FAILED = EnumChoice('failed', name=_('Ошибка'))

    FINAL_STATES = {
        DECLINED, APPLIED, FAILED,
    }

    UNSUCCESSFUL_STATES = {
        DECLINED, FAILED,
    }


class ERRORS(metaclass=EnumMeta):
    NO_APPROVERS = EnumChoice('no_approvers', name=_('Нет согласующих'))
    TRACKER_ERROR = EnumChoice('tracker_error', name=_('Ошибка трекера'))
    OEBS_ERROR = EnumChoice('oebs_error', name=_('Ошибка в OEBS'))
    ABC_ERROR = EnumChoice('abc_error', name=_('Ошибка в ABC'))
    NOT_APPROVED_IN_TIME = EnumChoice(
        'not_approved_in_time',
        name=_('Согласование не завершилось в отведенное время')
    )
