# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-12-30 06:21
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('services', '0106_auto_20201221_1750'),
    ]

    operations = [
        migrations.CreateModel(
            name='OEBSAgreement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('start_date', models.DateField(blank=True, null=True, verbose_name='Начало согласования')),
                ('end_date', models.DateField(blank=True, null=True, verbose_name='Окончание согласования')),
                ('issue', models.CharField(blank=True, max_length=32, null=True, verbose_name='Тикет на согласование')),
                ('repair_issue', models.CharField(blank=True, max_length=32, null=True, verbose_name='Тикет на починку')),
                ('state', models.CharField(choices=[('open', 'Открыто'), ('approving', 'Согласовывается'), ('approved', 'Согласовано'), ('declined', 'Отклонено'), ('syncing_with_oebs', 'Передано в OEBS'), ('applied', 'Применено'), ('failed', 'Ошибка')], default='open', max_length=32, verbose_name='Статус')),
                ('attributes', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Атрибуты')),
                ('action', models.CharField(choices=[('change_flags', 'Изменение флагов'), ('rename', 'Переименование'), ('move', 'Перемещение'), ('close', 'Закрытие'), ('delete', 'Удаление')], max_length=32, verbose_name='Тип согласования')),
                ('error_type', models.CharField(blank=True, choices=[('no_approvers', 'Нет согласующих'), ('tracker_error', 'Ошибка трекера'), ('oebs_error', 'Ошибка в OEBS'), ('abc_error', 'Ошибка в ABC')], max_length=32, null=True, verbose_name='Тип ошибки')),
                ('error_message', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True, verbose_name='Ошибка')),
                ('close_request', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='services.ServiceCloseRequest', verbose_name='Запрос на закрытие')),
                ('delete_request', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='services.ServiceDeleteRequest', verbose_name='Запрос на удаление')),
                ('move_request', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='services.ServiceMoveRequest', verbose_name='Запрос на перемещение')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='oebs_agreements', to='services.Service')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
