from django.contrib.postgres.fields import JSONField
from django.db import models
from django.utils.translation import gettext_lazy as _

from plan.common.models import TimestampedModel


class RunResult(TimestampedModel):
    """Описывает результат выполенения периодического фонового задания.

    При использовании декоратора periodic_task результат передаётся
    на вход функции задания в аргументе params.

    """
    name = models.CharField(
        _('Name'), unique=True, max_length=100,
        help_text=_('Unique task name')
    )

    data = JSONField(
        blank=True,
        default=dict,
        verbose_name=_('Data'),
        help_text=_('Previous run result data. Will be passed to next task run.')
    )

    class Meta:
        verbose_name = _('Run result')
        verbose_name_plural = _('Run results')

    def __str__(self):
        return self.name
