import functools
import logging

from plan.common.utils.tasks import lock_task
from .models import RunResult

log = logging.getLogger(__name__)


def periodic_task(name: str):
    """Декоратор позволяющий определить перидически выполняемое фоновое задание.
    Задание выполняется единовременно только в одном ДЦ.
    На вход функции подаётся словарь params, содержащий результаты предыдущего запуска.

    :param name: Уникальное имя задания.
        Будет использовано в качестве имени метрики, а также для сохранения
        результатов запуска задания.

    """
    def periodic_task_(func):

        @functools.wraps(func)
        def wrapper(self, **kwargs):
            log.info('Running scheduled %s ...', name)

            run_result, _ = RunResult.objects.get_or_create(name=name)

            result = func(params=run_result.data)
            run_result.data = result or {}
            run_result.save()

        return lock_task(last_finished_metric_name=name, bind=True)(wrapper)

    return periodic_task_
