import django_filters

from plan.api.exceptions import ValidationError
from plan.common.person import Person
from plan.staff.models import Staff


class ApprovableByFilter(django_filters.CharFilter):
    def filter(self, qs, value):
        if not value:
            return qs

        try:
            person = Person(Staff.objects.get(login=value))
        except Staff.DoesNotExist:
            raise ValidationError(detail='user does not exist')

        return qs.active().approvable_by(person)
