import django_filters

from rest_framework import viewsets

from plan.api import base
from plan.api.fields import MappingField
from plan.api.filters import PlanFilterSet
from plan.api.mixins import DefaultFieldsMixin, TvmAccessMixin
from plan.api.permissions import TvmAuthenticated
from plan.resources.models import ResourceTypeCategory
from plan.swagger import SwaggerResources


class TypeCategorySerializer(base.ModelSerializer):
    name = MappingField({'ru': 'name', 'en': 'name_en'})
    fields_mapping_ = {'name': ('name', 'name_en')}

    class Meta:
        model = ResourceTypeCategory
        fields = [
            'id',
            'name',
            'slug',
            'description',
        ]


class CategoryWithTypesFilter(django_filters.BooleanFilter):
    def filter(self, qs, value):
        if value:
            qs = qs.filter(resourcetype__isnull=False).distinct()

        return qs


class TypeCategoryFilter(PlanFilterSet):
    with_types = CategoryWithTypesFilter()

    class Meta:
        model = ResourceTypeCategory
        fields = ('name', 'name_en', 'slug', 'with_types')


class ResourceTypeCategoryView(base.OrderingMixin, viewsets.ModelViewSet):

    serializer_class = TypeCategorySerializer
    filter_class = TypeCategoryFilter
    queryset = ResourceTypeCategory.objects.all()
    http_method_names = ['get']


class V4ResourceTypeCategoryView(DefaultFieldsMixin, ResourceTypeCategoryView, TvmAccessMixin):
    """
    Категории типов ресурсов
    """
    default_swagger_schema = SwaggerResources

    permission_classes = [TvmAuthenticated]
    default_fields = ['id', 'slug']
