from django.utils.translation import ugettext_lazy as _

from rest_framework.serializers import ValidationError

from plan.api.exceptions import BadRequest
from plan.resources.api.base import validate_tag_affiliation


class ConstructorUrlRequestValidator(object):
    def __call__(self, attrs, *args, **kwargs):
        service = attrs.get('service')
        service_resource = attrs.get('service_resource')
        resource_type = attrs.get('resource_type')
        tags = attrs.get('tags')
        supplier_tags = attrs.get('supplier_tags')

        if not (service and resource_type) and not service_resource:
            raise ValidationError(
                _('Ожидается на вход либо идентификатор ресурса, либо идентификаторы сервиса и типа ресурса.')
            )

        if (service or resource_type) and service_resource:
            raise ValidationError(
                _('Ожидается на вход либо идентификатор ресурса, либо идентификаторы сервиса и типа ресурса, '
                  'но не оба сразу.')
            )

        if resource_type:
            try:
                validate_tag_affiliation(service, resource_type, tags, supplier_tags)
            except BadRequest as e:
                raise ValidationError(getattr(e, 'message', str(e)))
