from django.forms.models import ModelMultipleChoiceField, ModelChoiceField, ChoiceField
from django.utils.translation import ugettext_lazy as _

from plan.resources.models import ResourceTag, ResourceType, ServiceResource
from plan.services.models import Service
from plan.staff.models import Staff


class UserField(ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': Staff.objects.all(),
            'to_field_name': 'login',
            'error_messages': {
                'invalid_choice': _('Сервис не найден')
            },
        }
        defaults.update(kwargs)
        super(UserField, self).__init__(**defaults)


class ServiceField(ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': Service.objects.alive(),
            'error_messages': {
                'invalid_choice': _('Сервис не найден')
            },
        }
        defaults.update(kwargs)
        super(ServiceField, self).__init__(**defaults)


class ResourceTypeField(ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': ResourceType.objects.filter(form_id__isnull=False),
            'error_messages': {
                'invalid_choice': _('Тип ресурса не найден')
            },
        }
        defaults.update(kwargs)
        super(ResourceTypeField, self).__init__(**defaults)


class ResourceTagsField(ModelMultipleChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': ResourceTag.objects.all(),
            'error_messages': {
                'invalid_choice': _('Тег ресурса не найден')
            },
        }
        defaults.update(kwargs)
        super(ResourceTagsField, self).__init__(**defaults)


class RequestTypeField(ChoiceField):
    def __init__(self, *args, **kwargs):
        kwargs['label'] = _('Тип запроса')
        kwargs['choices'] = (
            ('request', _('Запрос ресурса')),
            ('provide', _('Предоставление ресурса')),
        )
        super(RequestTypeField, self).__init__(*args, **kwargs)


class ServiceResourceField(ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': ServiceResource.objects.all(),
            'error_messages': {
                'invalid_choice': _('Ресурс не найден')
            },
        }
        defaults.update(kwargs)
        super(ServiceResourceField, self).__init__(**defaults)
