from django import forms
from django.utils.translation import ugettext_lazy as _

from plan.api.exceptions import BadRequest
from plan.resources import fields
from plan.resources.api.base import validate_tag_affiliation


class ConstructorForm(forms.Form):
    service = fields.ServiceField(label=_('Сервис'), required=False)
    resource_type = fields.ResourceTypeField(label=_('Тип ресурса'), required=False)
    tags = fields.ResourceTagsField(label=_('Теги ресурса'), required=False)
    supplier_tags = fields.ResourceTagsField(label=_('Теги поставщика ресурса'), required=False)
    service_resource = fields.ServiceResourceField(label=_('Ресурс сервиса'), required=False)

    def clean(self):
        data = self.cleaned_data
        if not ((data.get('service') and data.get('resource_type')) or data.get('service_resource')):
            raise forms.ValidationError(
                _('Ожидается на вход либо идентификатор ресурса, либо идентификаторы сервиса и типа ресурса.')
            )

        if data.get('service_resource'):
            data['service'] = data['service_resource'].service
            data['resource_type'] = data['service_resource'].type

        service = data.get('service')
        resource_type = data.get('resource_type')
        tags = data.get('tags', [])
        supplier_tags = data.get('supplier_tags', [])

        try:
            validate_tag_affiliation(service, resource_type, tags, supplier_tags)
        except BadRequest as ex:
            message = ex.message.get('ru', ex.message.get('en', ''))
            raise forms.ValidationError(message)

        return data


class RequestForm(ConstructorForm):
    user = fields.UserField(label=_('Заказчик'))
