from plan.oebs.utils import is_oebs_related
from plan.api.exceptions import BadRequest


def process_form_forward(data, form_metadata, cleaned_data):
    attributes_names = (
        'upload_choice', 'balance_id',
    )

    attrs = {}
    service = cleaned_data['service']
    if not is_oebs_related(service=service, with_descendants=False):
        raise BadRequest(message={
            'ru': 'Сервис не сихронизирован с OEBS. Его нельзя разметить как точку агрегации биллинга',
            'en': 'The service is not synchronized with OEBS. It cannot be marked as billing aggregation point',
        })

    for field in data.values():
        constuctor_slug = field['question']['slug']
        if constuctor_slug in attributes_names:
            attrs[constuctor_slug] = field['value']

    result = {
        'name': 'Billing aggregation point',
        'attributes': attrs,
    }
    return result
