def _make_unique_obj_id(client_id, manager):
    if not manager:
        client_id = f'{client_id}-nomanager'
    return client_id


def process_form_forward(data, form_metadata):
    client_id = str(data['field_1']['value'])

    manager = (data.get('field_2') or {}).get('value')
    passport_login = (data.get('field_3') or {}).get('value')
    comment = (data.get('field_4') or {}).get('value')
    if comment == 'None':
        comment = None

    external_id = _make_unique_obj_id(client_id, manager)

    result = {
        'name': external_id,
        'external_id': external_id,
        'attributes': {
            'client_id': client_id,
            'comment': comment or '',
        }
    }
    if manager:
        result['attributes']['main_manager'] = manager
        result['attributes']['main_manager_passport_login'] = passport_login

    return result
