from plan.resources.processing import get_data_source_items


def process_form_backward(attributes, form_metadata):
    date_items = {
        item['text']: item['id']
        for item in form_metadata['fields']['store_for']['data_source']['items']
    }

    elements_free_url = form_metadata['fields']['data']['data_source']['filters'][0]['value']
    element_items = get_data_source_items(
        source_type='wiki-table-source',
        params={
            'free_url': elements_free_url,
            'suggest': attributes['data']
        },
    )

    subject_free_url = form_metadata['fields']['subject']['data_source']['filters'][0]['value']
    subject_items = get_data_source_items(
        source_type='wiki-table-source',
        params={
            'free_url': subject_free_url,
            'suggest': attributes['subject']
        },
    )

    simple_fields = (
        'service_from_slug', 'purpose', 'path_to_data',
    )

    result = {
        attr: attributes.get(attr)
        for attr in simple_fields
    }
    for key in (
        'is_storing',
        'is_using',
        'access_from_yql_sql',
        'access_from_api',
        'access_from_web_cloud',
        'access_from_file_based',
    ):
        value = attributes.get(key)
        if value and value != 'Нет':
            result[key] = 'True'

    result['subject'] = subject_items[attributes['subject']]
    result['data'] = element_items[attributes['data']]
    if attributes.get('store_in'):
        store_free_url = form_metadata['fields']['store_in']['data_source']['filters'][0]['value']
        store_items = get_data_source_items(
            source_type='wiki-table-source',
            params={
                'free_url': store_free_url,
                'suggest': attributes['store_in'],
            },
        )
        result['store_in'] = store_items[attributes['store_in']]
    if attributes.get('store_for'):
        result['store_for'] = date_items[attributes['store_for']]

    return result
